VERSION 5.00
Begin VB.Form FrontPanel 
   Appearance      =   0  'Flat
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Educ-8"
   ClientHeight    =   4575
   ClientLeft      =   150
   ClientTop       =   720
   ClientWidth     =   10920
   Icon            =   "Educ8.frx":0000
   LinkTopic       =   "Educ8"
   MaxButton       =   0   'False
   ScaleHeight     =   4575
   ScaleWidth      =   10920
   StartUpPosition =   3  'Windows Default
   Begin VB.Timer Timer2 
      Interval        =   5
      Left            =   480
      Top             =   4080
   End
   Begin Educ8.LED OpcodeLED 
      Height          =   375
      Index           =   0
      Left            =   6000
      Top             =   840
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   661
   End
   Begin Educ8.ToggleSwitch Switch1 
      Height          =   735
      Index           =   0
      Left            =   4200
      Top             =   3480
      Width           =   495
      _ExtentX        =   873
      _ExtentY        =   1296
   End
   Begin Educ8.LEDByte PC 
      Height          =   375
      Left            =   840
      TabIndex        =   0
      Top             =   840
      Width           =   3735
      _ExtentX        =   6588
      _ExtentY        =   661
      Was7Bits        =   -1  'True
   End
   Begin Educ8.LEDByte MA 
      Height          =   375
      Left            =   840
      TabIndex        =   1
      Top             =   1320
      Width           =   3735
      _ExtentX        =   6588
      _ExtentY        =   661
      Was7Bits        =   -1  'True
   End
   Begin Educ8.ToggleSwitch Run 
      Height          =   735
      Left            =   8040
      Top             =   3480
      Width           =   495
      _ExtentX        =   1296
      _ExtentY        =   2355
      Biased          =   -1  'True
   End
   Begin Educ8.LEDByte MB 
      Height          =   375
      Left            =   840
      TabIndex        =   2
      Top             =   1800
      Width           =   3735
      _ExtentX        =   6588
      _ExtentY        =   661
   End
   Begin Educ8.LEDByte AC 
      Height          =   375
      Left            =   840
      TabIndex        =   3
      Top             =   2280
      Width           =   3735
      _ExtentX        =   6588
      _ExtentY        =   661
   End
   Begin Educ8.ToggleSwitch Switch1 
      Height          =   735
      Index           =   1
      Left            =   3720
      Top             =   3480
      Width           =   495
      _ExtentX        =   873
      _ExtentY        =   1296
   End
   Begin Educ8.ToggleSwitch Switch1 
      Height          =   735
      Index           =   2
      Left            =   3240
      Top             =   3480
      Width           =   495
      _ExtentX        =   873
      _ExtentY        =   1296
   End
   Begin Educ8.ToggleSwitch Switch1 
      Height          =   735
      Index           =   3
      Left            =   2760
      Top             =   3480
      Width           =   495
      _ExtentX        =   873
      _ExtentY        =   1296
   End
   Begin Educ8.ToggleSwitch Switch1 
      Height          =   735
      Index           =   4
      Left            =   2280
      Top             =   3480
      Width           =   495
      _ExtentX        =   873
      _ExtentY        =   1296
   End
   Begin Educ8.ToggleSwitch Switch1 
      Height          =   735
      Index           =   5
      Left            =   1800
      Top             =   3480
      Width           =   495
      _ExtentX        =   873
      _ExtentY        =   1296
   End
   Begin Educ8.ToggleSwitch Switch1 
      Height          =   735
      Index           =   6
      Left            =   1320
      Top             =   3480
      Width           =   495
      _ExtentX        =   873
      _ExtentY        =   1296
   End
   Begin Educ8.ToggleSwitch Switch1 
      Height          =   735
      Index           =   7
      Left            =   840
      Top             =   3480
      Width           =   495
      _ExtentX        =   873
      _ExtentY        =   1296
   End
   Begin Educ8.ToggleSwitch LoadAddr 
      Height          =   735
      Left            =   6000
      Top             =   3480
      Width           =   495
      _ExtentX        =   873
      _ExtentY        =   1296
      Biased          =   -1  'True
      Colour          =   2
   End
   Begin Educ8.ToggleSwitch Deposit 
      Height          =   735
      Left            =   6480
      Top             =   3480
      Width           =   495
      _ExtentX        =   873
      _ExtentY        =   1296
      Biased          =   -1  'True
   End
   Begin Educ8.ToggleSwitch Examine 
      Height          =   735
      Left            =   6960
      Top             =   3480
      Width           =   495
      _ExtentX        =   873
      _ExtentY        =   1296
      Biased          =   -1  'True
   End
   Begin Educ8.ToggleSwitch Halt 
      Height          =   735
      Left            =   8520
      Top             =   3480
      Width           =   495
      _ExtentX        =   1296
      _ExtentY        =   2355
      Biased          =   -1  'True
      Colour          =   2
   End
   Begin Educ8.ToggleSwitch SingleCont 
      Height          =   735
      Left            =   9000
      Top             =   3480
      Width           =   495
      _ExtentX        =   1296
      _ExtentY        =   2355
      Colour          =   1
      State           =   1
   End
   Begin Educ8.ToggleSwitch Fast 
      Height          =   735
      Left            =   9480
      Top             =   3480
      Width           =   495
      _ExtentX        =   1296
      _ExtentY        =   2355
      Colour          =   1
      State           =   1
   End
   Begin Educ8.LED OpcodeLED 
      Height          =   375
      Index           =   1
      Left            =   6000
      Top             =   1320
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   661
   End
   Begin Educ8.LED OpcodeLED 
      Height          =   375
      Index           =   2
      Left            =   6000
      Top             =   1800
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   661
   End
   Begin Educ8.LED OpcodeLED 
      Height          =   375
      Index           =   3
      Left            =   6000
      Top             =   2280
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   661
   End
   Begin Educ8.LED OpcodeLED 
      Height          =   375
      Index           =   4
      Left            =   6480
      Top             =   2280
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   661
   End
   Begin Educ8.LED OpcodeLED 
      Height          =   375
      Index           =   5
      Left            =   6480
      Top             =   1800
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   661
   End
   Begin Educ8.LED OpcodeLED 
      Height          =   375
      Index           =   6
      Left            =   6480
      Top             =   1320
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   661
   End
   Begin Educ8.LED OpcodeLED 
      Height          =   375
      Index           =   7
      Left            =   6480
      Top             =   840
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   661
   End
   Begin Educ8.LED RunLED 
      Height          =   375
      Left            =   9000
      Top             =   840
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   661
   End
   Begin Educ8.LED FetchLED 
      Height          =   375
      Left            =   9000
      Top             =   1320
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   661
   End
   Begin Educ8.LED DeferLED 
      Height          =   375
      Left            =   9000
      Top             =   1800
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   661
   End
   Begin Educ8.LED ExecuteLED 
      Height          =   375
      Left            =   9000
      Top             =   2280
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   661
   End
   Begin VB.Frame Frame1 
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      Caption         =   "Frame1"
      Height          =   2055
      Left            =   720
      TabIndex        =   4
      Top             =   720
      Width           =   3975
   End
   Begin VB.Frame Frame3 
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      Caption         =   "Frame2"
      Height          =   2055
      Left            =   8880
      TabIndex        =   6
      Top             =   720
      Width           =   1095
   End
   Begin VB.Frame Frame2 
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      Caption         =   "Frame2"
      Enabled         =   0   'False
      Height          =   2055
      Left            =   5880
      TabIndex        =   5
      Top             =   720
      Width           =   1095
   End
   Begin VB.Label Educ8Label 
      Caption         =   "EDUC-8 MICROCOMPUTER"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1320
      TabIndex        =   38
      Top             =   120
      Width           =   2535
   End
   Begin VB.Image EALogo 
      Enabled         =   0   'False
      Height          =   600
      Left            =   720
      Picture         =   "Educ8.frx":030A
      Top             =   0
      Width           =   600
   End
   Begin VB.Image Image4 
      Enabled         =   0   'False
      Height          =   135
      Left            =   8520
      Picture         =   "Educ8.frx":160C
      Top             =   3240
      Width           =   450
   End
   Begin VB.Image Image3 
      Enabled         =   0   'False
      Height          =   135
      Left            =   8040
      Picture         =   "Educ8.frx":198A
      Top             =   3240
      Width           =   450
   End
   Begin VB.Image Image2 
      Enabled         =   0   'False
      Height          =   135
      Left            =   6960
      Picture         =   "Educ8.frx":1D08
      Top             =   3240
      Width           =   450
   End
   Begin VB.Image Image1 
      Enabled         =   0   'False
      Height          =   135
      Left            =   6480
      Picture         =   "Educ8.frx":2086
      Top             =   3240
      Width           =   450
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "SLOW FAST"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   9480
      TabIndex        =   37
      Top             =   3000
      Width           =   510
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label7 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "SINGLE CONT"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   8955
      TabIndex        =   36
      Top             =   3000
      Width           =   600
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label6 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "HALT"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   180
      Left            =   8520
      TabIndex        =   35
      Top             =   3000
      Width           =   510
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "RUN"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   180
      Left            =   8040
      TabIndex        =   34
      Top             =   3000
      Width           =   510
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "EXAM"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   180
      Left            =   6930
      TabIndex        =   33
      Top             =   3000
      Width           =   570
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "DEP"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   180
      Left            =   6480
      TabIndex        =   32
      Top             =   3000
      Width           =   510
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "LOAD ADDR"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   5940
      TabIndex        =   31
      Top             =   3000
      Width           =   510
      WordWrap        =   -1  'True
   End
   Begin VB.Line Line1 
      BorderWidth     =   5
      Index           =   2
      X1              =   3360
      X2              =   4560
      Y1              =   3360
      Y2              =   3360
   End
   Begin VB.Line Line1 
      BorderWidth     =   5
      Index           =   1
      X1              =   2400
      X2              =   3120
      Y1              =   3360
      Y2              =   3360
   End
   Begin VB.Line Line1 
      BorderWidth     =   5
      Index           =   0
      X1              =   960
      X2              =   2160
      Y1              =   3360
      Y2              =   3360
   End
   Begin VB.Label Label0 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "7"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Index           =   7
      Left            =   1005
      TabIndex        =   30
      Top             =   3000
      Width           =   165
   End
   Begin VB.Label Label0 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "6"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Index           =   6
      Left            =   1485
      TabIndex        =   29
      Top             =   3000
      Width           =   165
   End
   Begin VB.Label Label0 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "5"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Index           =   5
      Left            =   1965
      TabIndex        =   28
      Top             =   3000
      Width           =   165
   End
   Begin VB.Label Label0 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "4"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Index           =   4
      Left            =   2445
      TabIndex        =   27
      Top             =   3000
      Width           =   165
   End
   Begin VB.Label Label0 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "3"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Index           =   3
      Left            =   2925
      TabIndex        =   26
      Top             =   3000
      Width           =   165
   End
   Begin VB.Label Label0 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "2"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Index           =   2
      Left            =   3405
      TabIndex        =   25
      Top             =   3000
      Width           =   165
   End
   Begin VB.Label Label0 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "1"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Index           =   1
      Left            =   3885
      TabIndex        =   24
      Top             =   3000
      Width           =   165
   End
   Begin VB.Label Label0 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "0"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Index           =   0
      Left            =   4320
      TabIndex        =   23
      Top             =   3000
      Width           =   255
   End
   Begin VB.Label ACLabel 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "AC"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   4800
      TabIndex        =   22
      Top             =   2280
      Width           =   270
   End
   Begin VB.Label MBLabel 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "MB"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   4800
      TabIndex        =   21
      Top             =   1800
      Width           =   300
   End
   Begin VB.Label MALabel 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "MA"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   4800
      TabIndex        =   20
      Top             =   1320
      Width           =   300
   End
   Begin VB.Label PCLabel 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "PC"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   4800
      TabIndex        =   19
      Top             =   840
      Width           =   270
   End
   Begin VB.Label DCALabel 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "DCA"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   5325
      TabIndex        =   18
      Top             =   2280
      Width           =   405
   End
   Begin VB.Label ISZLabel 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "ISZ"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   5430
      TabIndex        =   17
      Top             =   1800
      Width           =   300
   End
   Begin VB.Label TADLabel 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "TAD"
      DataField       =   "Run"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   5340
      TabIndex        =   16
      Top             =   1320
      Width           =   390
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "AND"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   5325
      TabIndex        =   15
      Top             =   840
      Width           =   405
   End
   Begin VB.Label JMSLabel 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "JMS"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   7080
      TabIndex        =   14
      Top             =   2280
      Width           =   405
   End
   Begin VB.Label JMPLabel 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "JMP"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   7080
      TabIndex        =   13
      Top             =   1800
      Width           =   405
   End
   Begin VB.Label IOTLabel 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "IOT"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   7080
      TabIndex        =   12
      Top             =   1320
      Width           =   330
   End
   Begin VB.Label OPRLabel 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "OPR"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   7080
      TabIndex        =   11
      Top             =   840
      Width           =   420
   End
   Begin VB.Label ExecuteLabel 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "EXECUTE"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   7905
      TabIndex        =   10
      Top             =   2280
      Width           =   885
   End
   Begin VB.Label DeferLabel 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "DEFER"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   8160
      TabIndex        =   9
      Top             =   1800
      Width           =   630
   End
   Begin VB.Label FetchLabel 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "FETCH"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   8160
      TabIndex        =   8
      Top             =   1320
      Width           =   630
   End
   Begin VB.Label RunLabel 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "RUN"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   8385
      TabIndex        =   7
      Top             =   840
      Width           =   405
   End
   Begin VB.Menu File 
      Caption         =   "&File"
      Index           =   1
      Begin VB.Menu Mem_Read 
         Caption         =   "&Open"
         Index           =   1
      End
      Begin VB.Menu Mem_Save 
         Caption         =   "&Save"
         Index           =   2
         Shortcut        =   ^S
      End
      Begin VB.Menu Mem_SaveAs 
         Caption         =   "Save &As"
         Index           =   3
      End
      Begin VB.Menu Educ8_Exit 
         Caption         =   "E&xit"
         Index           =   4
      End
   End
   Begin VB.Menu Peripherals 
      Caption         =   "&Peripherals"
      Enabled         =   0   'False
      Begin VB.Menu Per_Reader 
         Caption         =   "Tape Reader"
         Shortcut        =   ^R
      End
      Begin VB.Menu Per_Punch 
         Caption         =   "Tape Punch"
      End
      Begin VB.Menu Per_Keyboard 
         Caption         =   "Keyboard"
      End
      Begin VB.Menu Per_Printer 
         Caption         =   "Printer"
         Shortcut        =   ^P
      End
   End
   Begin VB.Menu Help 
      Caption         =   "&Help"
      Index           =   2
      NegotiatePosition=   3  'Right
      Begin VB.Menu About 
         Caption         =   "&About"
         Index           =   1
      End
   End
End
Attribute VB_Name = "FrontPanel"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Educ-8 Emulator
'  2004 Lawrence Wilkinson <lawrence@ljw.me.uk>

' This program is free software; you can redistribute it and/or modify it under the terms of
' the GNU General Public License as published by the Free Software Foundation; either version 2
' of the License, or (at your option) any later version.

' This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
' even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License along with this program; if not,
' write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

' Event-generating switches:
Private WithEvents LoadSw As ToggleSwitch
Attribute LoadSw.VB_VarHelpID = -1
Private WithEvents DepositSw As ToggleSwitch
Attribute DepositSw.VB_VarHelpID = -1
Private WithEvents ExamineSw As ToggleSwitch
Attribute ExamineSw.VB_VarHelpID = -1
Private WithEvents RunSw As ToggleSwitch
Attribute RunSw.VB_VarHelpID = -1
Private WithEvents StopSw As ToggleSwitch
Attribute StopSw.VB_VarHelpID = -1
Private WithEvents FastSw As ToggleSwitch
Attribute FastSw.VB_VarHelpID = -1

' Application state:

Private CurrentFile As String

' Parsing

Private labels(255) As String
Private values(255) As Integer
Private numSymbols As Integer
Private fixups(255) As String
Private fixupLoc(255) As Integer
Private fixupIsInstr(255) As Boolean
Private numFixups As Integer
Private currentLine As String
Private linePtr As String
Private char As String
Private token As String
Private Enum TokenEnum
  endofline
  constant
  identifier
  comment
  charString
  End Enum
Private tokenType As TokenEnum
Private currentLoc As Integer
Private errorList As String

' Peripherals:
' Private PrinterPeripheral As Printer
' Private KeyboardBuffer As String
' Private TapeReaderPeripheral As Object
' Private TapePunchPeripheral As Object
' KeyboardBuffer = KeyboardBuffer + Chr$(KeyAscii)

' Computer state:
Private Enum ExecPhase
    Fetch
    Defer
    Execute
    End Enum
Private ram(256) As Integer
Private phase As ExecPhase
Private IR As Integer

' Menu Handlers
 
Private Sub About_Click(Index As Integer)
frmAbout.Show
End Sub

Private Sub Educ8_Exit_Click(Index As Integer)
Unload Me
End Sub


Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
KeyboardBuffer = KeyboardBuffer + Chr$(KeyCode)
End Sub

Private Sub Mem_Read_Click(Index As Integer)
Dim f As Integer
Dim cd As CommonDialog
Dim s As String
Set cd = New CommonDialog
numSymbols = 0
errorList = ""
f = FreeFile
currentLoc = 0
cd.Filter = "*.txt"
cd.ShowOpen
If cd.FileName <> "" Then
CurrentFile = cd.FileName
Open cd.FileName For Input As f
Do While Not EOF(f)
  Line Input #f, currentLine
  parseLine
  Loop
Close f
If errorList <> "" Then MsgBox errorList, , "File errors"
End If
End Sub

Private Sub Mem_Save_Click(Index As Integer)
Dim f As Integer
Dim i As Integer
Dim cd As CommonDialog

If CurrentFile = "" Then
  Mem_SaveAs_Click (Index)
 Else
  i = 0
  f = FreeFile
  Open CurrentFile For Output As f
  For i = 0 To 255
    Print #f, toOctal(ram(i))
  Next i
  Close f
End If
End Sub

Private Sub Mem_SaveAs_Click(Index As Integer)
Dim f As Integer
Dim i As Integer
Dim cd As CommonDialog

Set cd = New CommonDialog
cd.FileName = CurrentFile
cd.Filter = "*.txt"
cd.ShowSave
If cd.FileName <> "" Then
CurrentFile = cd.FileName
i = 0
f = FreeFile
Open cd.FileName For Output As f
For i = 0 To 255
  Print #f, toOctal(ram(i))
  Next i
Close f
End If
End Sub

' Private Sub Per_Printer_Click()
' Toggle printer on and off
' Per_Printer.Checked = Not Per_Printer.Checked
' If Per_Printer.Checked Then Printer.Show Else Printer.Hide
' End Sub

' General event handlers

Private Sub Form_Load()
Set LoadSw = LoadAddr
Set DepositSw = Deposit
Set ExamineSw = Examine
Set RunSw = Run
Set StopSw = Halt
Set FastSw = Fast
' Set PrinterPeripheral = New Printer
SetPhase (Fetch)
AC.SetValue (Rnd(1) * 255)
PC.SetValue (Rnd(1) * 255)
MA.SetValue (Rnd(1) * 255)
MB.SetValue (Rnd(1) * 255)
Randomize
For i = 0 To 255
  ram(i) = Rnd(255) * 255
  Next i
End Sub

Private Sub Form_Unload(Cancel As Integer)
' PrinterPeripheral.Hide
' Unload PrinterPeripheral
End Sub

' Panel switch handlers

Sub LoadSw_NotifyUp()
PC.SetValue (Switches())
SetPhase (Fetch)
End Sub

Sub DepositSw_NotifyDown()
MA.SetValue (PC.GetValue)
PC.Increment
MB.SetValue (Switches())
ram(MA.GetValue()) = MB.GetValue
StopRun
End Sub

Sub ExamineSw_NotifyDown()
StopRun
MA.SetValue (PC.GetValue)
PC.Increment
MB.SetValue (ram(MA.GetValue))
End Sub

Sub RunSw_NotifyDown()
Start
End Sub

' General operation routines

Sub Start()
RunLED.SetState (1)
Timer2.Enabled = True
End Sub

Sub StopRun()
RunLED.SetState (0)
End Sub

Private Function Switches()
b = 1
r = 0
For i = 0 To 7
    If Switch1(i).State = 1 Then r = r + b
    b = b * 2
    Next i
Switches = r
End Function

Private Function toOctal(n As Integer) As String
' Convert an integer to an octal string in 377 format
Dim dig1 As Integer
Dim dig2 As Integer
Dim dig3 As Integer
dig1 = (n And 192) / 64
dig2 = (n And 56) / 8
dig3 = n And 7
toOctal = Chr$(48 + dig1) + Chr$(48 + dig2) + Chr$(48 + dig3)
End Function

' Instruction execution

Private Sub Timer2_Timer()
Select Case phase
Case Fetch
  If RunLED.State = 1 Then FetchPhase Else Timer2.Enabled = False
Case Defer
  DeferPhase
Case Execute
  ExecutePhase
End Select
If Fast.State = 1 Then Timer2.Interval = 5 Else Timer2.Interval = 1000
End Sub

Private Sub FetchPhase()
Dim opcode As Integer
MA.SetValue (PC.GetValue)
PC.Increment
MB.SetValue (ram(MA.GetValue))
IR = MB.GetValue
opcode = (IR And 224) / 32
For i = 0 To 7
  If i = opcode Then OpcodeLED(i).SetState (1) Else OpcodeLED(i).SetState (0)
Next
If (opcode < 6) Then
  ' Put upper bits of address into MB, leaving lower 4 bits there from the instruction
  MB.SetValue ((MA.GetValue And 240) + (MB.GetValue And 15))
  If (IR And 16) > 0 Then
    SetPhase (Defer)
  Else
    SetPhase (Execute)
  End If
Else
  SetPhase (Execute)
End If
End Sub

Private Sub DeferPhase()
MA.SetValue (MB.GetValue)
MB.SetValue (ram(MA.GetValue))
SetPhase (Execute)
End Sub

Private Sub ExecutePhase()
Dim bits As Integer
Dim skip As Boolean
Select Case (IR And 224) / 32
Case 0 ' AND
    MA.SetValue (MB.GetValue)
    AC.SetValue (AC.GetValue And ram(MA.GetValue))
Case 1 ' TAD
    MA.SetValue (MB.GetValue)
    AC.SetValue (AC.GetValue + ram(MA.GetValue))
Case 2 ' ISZ
    MA.SetValue (MB.GetValue)
    MB.SetValue (ram(MA.GetValue) + 1)
    ram(MA.GetValue) = MB.GetValue
    If MB.GetValue = 0 Then PC.Increment
Case 3 ' DCA
    MA.SetValue (MB.GetValue)
    MB.SetValue (AC.GetValue)
    AC.SetValue (0)
    ram(MA.GetValue) = MB.GetValue
Case 4 ' JMS
    MA.SetValue (MB.GetValue)
    MB.SetValue (PC.GetValue)
    ram(MA.GetValue) = MB.GetValue
    PC.SetValue (MA.GetValue + 1)
Case 5 ' JMP
    MA.SetValue (MB.GetValue)
    PC.SetValue (MA.GetValue)
Case 6 ' IOT
    ' IN 0 = Tape reader
    ' IN 1 = Keyboard
    ' OUT 0 = Tape punch
    ' OUT 1 = Printer
    bits = MB.GetValue And 31
    dev = (bits And 24)
    skip = False
    Select Case dev
    Case 0  ' Tape reader
    Case 8  ' Keyboard
    Case 16 ' Tape punch
    Case 24 ' Printer
'      If (bits And 1) > 0 Then skip = True  ' Always ready
'      If (bits And 2) > 0 Then
'        Printer.PrintCharacter (AC.GetValue) ' Print the character
'        AC.SetValue (0) ' Not documented?
'        End If
    End Select
    If skip Then PC.Increment
Case 7 ' OPR
    bits = MB.GetValue And 31
    skip = False
    If (bits And 16) > 0 Then
      ' SZA
      If (bits And 8) > 0 Then skip = (AC.GetValue = 0)
      ' SMA
      If (bits And 4) > 0 Then skip = (AC.GetValue > 127)
      ' RAR
      If (bits And 2) > 0 Then AC.SetValue (AC.GetValue / 2 + (AC.GetValue And 1) * 128)
      ' HLT
      If (bits And 1) > 0 Then StopRun
    Else
      ' CLA
      If (bits And 8) > 0 Then AC.SetValue (0)
      ' CMA
      If (bits And 4) > 0 Then AC.SetValue (255 - AC.GetValue)
      ' RAL
      If (bits And 2) > 0 Then AC.SetValue (AC.GetValue * 2 + (AC.GetValue And 128) / 128)
      ' IAC
      If (bits And 1) > 0 Then AC.SetValue (AC.GetValue + 1)
    End If
    If skip Then PC.Increment
End Select
SetPhase (Fetch)
If (SingleCont.State = 0) Or (StopSw.State = 1) Then StopRun
End Sub

Private Sub SetPhase(p As ExecPhase)
phase = p
If p = Fetch Then FetchLED.SetState (1) Else FetchLED.SetState (0)
If p = Defer Then DeferLED.SetState (1) Else DeferLED.SetState (0)
If p = Execute Then ExecuteLED.SetState (1) Else ExecuteLED.SetState (0)
End Sub

' Parsing functions

Private Function lookupSymbol(s As String) As Integer
lookupSymbol = -32768
For i = 1 To numSymbols
  If labels(i) = s Then
    lookupSymbol = values(i)
    End If
Next i
End Function

Private Sub addFixup(label As String, loc As Integer, isInstr As Boolean)
  numFixups = numFixups + 1
  fixups(numFixups) = label
  fixupLoc(numFixups) = loc
  fixupIsInstr(numFixups) = isInstr
End Sub

Private Sub DefineLabel(label As String, val As Integer)
  numSymbols = numSymbols + 1
  labels(numSymbols) = label
  values(numSymbols) = val
  ' Check fixups
  For i = 1 To numFixups
  If fixups(i) = label Then
    If fixupIsInstr(i) Then
      If (val And 240) <> (fixupLoc(i) And 240) Then
        ' Error - not on same page
        emitError "Operand at addr " + toOctal(fixupLoc(i)) + " not on current page (" + toOctal(currentLoc And 240) + ")"
      Else
        ram(fixupLoc(i)) = ram(fixupLoc(i)) Or (val And 15)
      End If
    Else
      ram(fixupLoc(i)) = val
    End If
    fixups(i) = "" ' Fixup is no longer needed
  End If
  Next i
End Sub

Private Function convChar(s As String)
If Len(s) = 3 And Left$(s, 1) = "'" And Right$(s, 1) = "'" Then
  ' Character constant
  convChar = InStr("@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_ !" + Chr$(34) + "$%&'()*+,-./0123456789:;<=>?", Mid$(s, 2, 1)) - 1
Else
  convChar = -32768
End If
End Function

Private Function eval(s As String, loc As Integer, isInstr As Boolean) As Integer
v = convOctal(s)
If v = -32768 Then v = convChar(s)
If v = -32768 Then v = lookupSymbol(s)
If v = -32768 Then
  If Left$(s, 2) = ".+" Then
    v = loc + eval(Mid$(s, 3), -1, False)
  ElseIf Left$(s, 2) = ".-" Then
    v = loc - eval(Mid$(s, 3), -1, False)
  End If
End If
If v = -32768 And loc >= 0 Then addFixup s, loc, isInstr
eval = v
End Function

Private Function convOctal(s As String) As Integer
' Convert an octal string in 737/37/7 format to an integer
Dim dig As Integer
Dim valid As Boolean
Dim val As Integer
val = 0
s = LTrim(RTrim(s))
valid = (Len(s) > 0)
For i = 1 To Len(s)
  dig = Asc(Mid$(s, i, 1)) - 48
  If dig < 0 Or dig > 7 Then
    valid = False
  Else
    val = val * 8 + dig
  End If
Next i
If valid Then
  convOctal = val
Else
  convOctal = -32768
End If
End Function

Private Function lookupMnemonic(s As String) As Integer
lookupMnemonic = -32768
Select Case UCase$(s)
Case "AND"
  lookupMnemonic = 0
Case "TAD"
  lookupMnemonic = 32
Case "ISZ"
  lookupMnemonic = 64
Case "DCA"
  lookupMnemonic = 96
Case "JMS"
  lookupMnemonic = 128
Case "JMP"
  lookupMnemonic = 160
Case "NOP"
  lookupMnemonic = 224
Case "IAC"
  lookupMnemonic = 225
Case "RAL"
  lookupMnemonic = 226
Case "CMA"
  lookupMnemonic = 228
Case "CLA"
  lookupMnemonic = 232
Case "HLT"
  lookupMnemonic = 241
Case "RAR"
  lookupMnemonic = 242
Case "SMA"
  lookupMnemonic = 244
Case "SZA"
  lookupMnemonic = 248
Case "CLA,IAC"
  lookupMnemonic = 233
Case "IAC,CLA"
  lookupMnemonic = 233
Case "CLA,CMA"
  lookupMnemonic = 236
Case "CMA,CLA"
  lookupMnemonic = 236
Case "CMA,IAC"
  lookupMnemonic = 229
Case "IAC,CMA"
  lookupMnemonic = 229
Case "SZA,SMA"
  lookupMnemonic = 252
Case "SMA,SZA"
  lookupMnemonic = 252
Case "SKF"
  lookupMnemonic = 193
Case "SDF"
  lookupMnemonic = 209
Case "KRS"
  lookupMnemonic = 194
Case "LDS"
  lookupMnemonic = 210
Case "RKF"
  lookupMnemonic = 196
Case "RDF"
  lookupMnemonic = 212
Case "KRB"
  lookupMnemonic = 198
Case "LDB"
  lookupMnemonic = 214
End Select
End Function

Private Function isSpace(c As String) As Boolean
isSpace = (c = " ") Or (c = Chr$(9))
End Function

Private Sub getChar()
If linePtr <= Len(currentLine) Then
  char = Mid$(currentLine, linePtr, 1)
  linePtr = linePtr + 1
Else
  char = ""
End If
End Sub

Private Sub skipBlanks()
  While isSpace(char)
    getChar
  Wend
End Sub

Private Sub getToken()
token = ""
skipBlanks
If char = "" Then
  tokenType = endofline
ElseIf char = "/" Then
  ' Comment - skip rest of line
  getChar
  While (char <> "")
    token = token + char
    getChar
  Wend
  tokenType = comment
ElseIf char = "'" Or char = Chr$(34) Then
  ' Get character string
  firstChar = char
  getChar
  While (char <> firstChar) And (char <> "")
    token = token + char
    getChar
  Wend
  getChar
  tokenType = charString
ElseIf InStr("01234567", char) <> 0 Then
  ' Get number
  token = char
  getChar
  While InStr("01234567", char) <> 0 And char <> ""
    token = token + char
    getChar
  Wend
  tokenType = constant
Else
  While Not isSpace(char) And (char <> "")
    token = token + char
    getChar
  Wend
  tokenType = identifier
End If
End Sub

Private Sub emit(b As Integer)
    ram(currentLoc) = b
    currentLoc = currentLoc + 1
    If currentLoc > 255 Then currentLoc = 255
End Sub

Private Sub emitError(e As String)
errorList = errorList + currentLine + Chr$(13) + ">" + e + Chr$(13)
End Sub

Private Sub parseLine()
' Check for (a) constant (b) instruction
Dim p As Integer 'Parameters
linePtr = 1
getChar
getToken

If tokenType = identifier And Len(token) > 1 And Right$(token, 1) = "," Then
    ' Label
      DefineLabel Left$(token, Len(token) - 1), currentLoc
      getToken
End If

Select Case tokenType
Case comment
Case constant
    emit (convOctal(token))
    getToken
Case identifier
    ' Instruction mnemonic?
    mn = lookupMnemonic(token)
    If (mn < 0) Then
        ' Label?
        b = eval(token, currentLoc, False)
        If b <> -32768 Then
            ' Value
            getToken
            emit (b)
        Else
            ' Fix up later
            getToken
            emit (0)
        End If
    Else
      getToken
      If (mn < 192) Then
        ' Mem ref instr
        If tokenType = identifier And token = "I" Then
          getToken
          mn = mn + 16
          End If
        p = eval(token, currentLoc, True)
        If p <> -32768 Then
          If (p And 240) = (currentLoc And 240) Then
            mn = mn + (p And 15)
          Else
            ' Error - not on current page
            emitError "Operand not on current page (" + toOctal(currentLoc And 240) + ")"
          End If
        End If
      ElseIf (mn < 224) Then
        ' IOT instr
        mn = mn + (eval(token, -1, False) And 1) * 8
      Else
        ' OPR instr
      End If
      emit (mn)
    End If
Case charString
  For i = 1 To Len(token)
    b = InStr("@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_ !" + Chr$(34) + "$%&'()*+,-./0123456789:;<=>?", Mid$(token, i, 1)) - 1
    If b < 0 Then b = 63 ' Change unknown to '?'
    emit (b)
  Next i
End Select
End Sub
